#pragma once

#include "BaseShader.h"

using namespace std;
using namespace DirectX;

//Shader used to apply glow to a texture with the specified intensity
class GlowShader : public BaseShader
{
	public:
		struct GlowIntensityBufferType
		{
			XMFLOAT4 intensity;	//Intensity of the glow
		};

		GlowShader(ID3D11Device* device, HWND hwnd);
		~GlowShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &worldMatrix, const XMMATRIX &viewMatrix, const XMMATRIX &projectionMatrix, ID3D11ShaderResourceView* sceneRenderTexture, XMFLOAT4 intensity);

	private:
		void initShader(const wchar_t* vs, const wchar_t* ps);
		ID3D11Buffer* glowBuffer;
		ID3D11SamplerState* sampleState;
	};
